<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="mnlno"></xsl:variable>
<xsl:variable name="edit"></xsl:variable>
<xsl:variable name="id"></xsl:variable>
<xsl:template match="/">
	<table border="1" cellspacing="0" cellpadding="3" width="100%" bordercolordark="#FFFFFF" bordercolor="#777777" id="tbl">
		<tr style='color:captiontext;' bgcolor='activecaption'>
			<th colspan="2" align="left">
				My Note
			</th>
			<xsl:apply-templates select="//INFO[@ID=$id and @MNLNO=$mnlno]">
			</xsl:apply-templates>
		</tr>
	</table>
	<table border="0" align="center" cellspacing="5">
		<tr>
			<xsl:if test="$edit='true'">
				<td>
					<input type="button" id="Btn" value="Save">
						<xsl:attribute name="onClick">
							saveItem('<xsl:value-of select="$id"/>')
						</xsl:attribute>
					</input>
				</td>
			</xsl:if>
			<xsl:if test="$edit='false'">
				<td>
					<input type="button" id="Btn" value="Edit...">
						<xsl:attribute name="onClick">
							editItem('<xsl:value-of select="$id"/>')
						</xsl:attribute>
					</input>
				</td>
			</xsl:if>
			<td>
				<input type="button" id="Btn" value="Cancel" onClick="window.close();"/>
			</td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="/MYNOTE/INFO">
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Title
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<xsl:if test="@TITLE[. != '']"><xsl:value-of select="@TITLE"/></xsl:if>
				<xsl:if test="@TITLE[. = '']"><br/></xsl:if>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<input type="text" name="title" size="71">
					<xsl:attribute name="value">
						<xsl:if test="@TITLE[. != '']"><xsl:value-of select="@TITLE"/></xsl:if>
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Model Name
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<xsl:if test="MODEL[. != '']"><xsl:value-of select="MODEL"/></xsl:if>
				<xsl:if test="MODEL[. = '']"><br/></xsl:if>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<input type="text" name="modelname" size="71">
					<xsl:attribute name="value">
						<xsl:if test="MODEL[. != '']"><xsl:value-of select="MODEL"/></xsl:if>
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Manual No.
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<xsl:if test="@MNLNO[. != '']"><xsl:value-of select="@MNLNO"/></xsl:if>
				<xsl:if test="@MNLNO[. = '']"><br/></xsl:if>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<input type="text" name="mnlno" size="71">
					<xsl:attribute name="value">
						<xsl:if test="@MNLNO[. != '']"><xsl:value-of select="@MNLNO"/></xsl:if>
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Block No.
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<a>
					<xsl:attribute name="href">
						javascript:SearchDraws(<xsl:value-of select="@VIEW"/>,'<xsl:value-of select="@DRAWS"/>')
					</xsl:attribute>
				</a>
				<xsl:if test="MODEL/@BLOCKNO[. != '']"><xsl:value-of select="MODEL/@BLOCKNO"/></xsl:if>
				<xsl:if test="MODEL/@BLOCKNO[. = '']">??</xsl:if>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<input type="text" name="block" size="71">
					<xsl:attribute name="value">
						<xsl:if test="MODEL/@BLOCKNO[. != '']"><xsl:value-of select="MODEL/@BLOCKNO"/></xsl:if>
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Ref No.
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<xsl:if test="MODEL/@BLOCKNO[. != '']">
					<a>
						<xsl:attribute name="href">
							javascript:SearchDraws(<xsl:value-of select="@VIEW"/>,'<xsl:value-of select="@DRAWS"/>');SerachPartsRef('<xsl:value-of select="MODEL/@REFNO"/>','<xsl:value-of select="MODEL/@BLOCKNO"/>');
						</xsl:attribute>
					</a>
				</xsl:if>
				<xsl:if test="MODEL/@REFNO[. != '']"><xsl:value-of select="MODEL/@REFNO"/></xsl:if>
				<xsl:if test="MODEL/@REFNO[. = '']"><br/></xsl:if>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<input type="text" name="refno" size="71">
					<xsl:attribute name="value">
						<xsl:if test="MODEL/@REFNO[. != '']"><xsl:value-of select="MODEL/@REFNO"/></xsl:if>
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Note.
		</th>
		<td>
			<textarea name="note" rows="6" cols="73">
				<xsl:if test="$edit='false'">
					<xsl:attribute name="readonly">readonly</xsl:attribute>
				</xsl:if>
				<xsl:value-of select="NOTE"/>
			</textarea>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Note Class.
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<xsl:if test="NOTE/@CLASS[. != '']"><xsl:value-of select="NOTE/@CLASS"/></xsl:if>
				<xsl:if test="NOTE/@CLASS[. = '']"><br/></xsl:if>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<select name="noteclass" size="1">
					<option value="Note">Note</option>
					<option value="Reference">Reference</option>
					<option value="Opinion">Opinion</option>
					<option value="Other">Other</option>
				</select>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Registrar
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<xsl:if test="REGISTRAR/@EMAIL[. != '']">
					<a>
						<xsl:attribute name="href">
							mailto:<xsl:value-of select="REGISTRAR/@EMAIL"/>
						</xsl:attribute>
						<xsl:if test="REGISTRAR[. != '']"><xsl:value-of select="REGISTRAR"/></xsl:if>
						<xsl:if test="REGISTRAR[. = '']"><br/></xsl:if>
					</a>
				</xsl:if>
				<xsl:if test="REGISTRAR/@EMAIL[. = '']">
					<xsl:if test="REGISTRAR[. != '']"><xsl:value-of select="REGISTRAR"/></xsl:if>
					<xsl:if test="REGISTRAR[. = '']"><br/></xsl:if>
				</xsl:if>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<input type="text" name="registrar" size="71">
					<xsl:attribute name="value">
						<xsl:if test="REGISTRAR[. != '']"><xsl:value-of select="REGISTRAR"/></xsl:if>
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
	<xsl:if test="$edit='true'">
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Registrar e-mail
		</th>
		<td>
			<input type="text" name="email" size="71">
				<xsl:attribute name="value">
					<xsl:if test="REGISTRAR/@EMAIL[. != '']"><xsl:value-of select="REGISTRAR/@EMAIL"/></xsl:if>
				</xsl:attribute>
			</input>
		</td>
	</tr>
	</xsl:if>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Date
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<xsl:if test="@DATE[. != '']"><xsl:value-of select="@DATE"/></xsl:if>
				<xsl:if test="@DATE[. = '']"><br/></xsl:if>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<input type="text" name="regdate" size="71">
					<xsl:attribute name="value">
						<xsl:if test="@DATE[. != '']"><xsl:value-of select="@DATE"/></xsl:if>
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Attach File
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="ATTACH"/>
					</xsl:attribute>
					<xsl:attribute name="target">_blank</xsl:attribute>
					<xsl:if test="ATTACH[. != '']"><xsl:value-of select="ATTACH"/></xsl:if>
					<xsl:if test="ATTACH[. = '']"><br/></xsl:if>
				</a>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<input type="file" name="attach" size="55"/>
			</xsl:if>
		</td>
	</tr>
	<tr>
		<th bgcolor="threedface" align="left" nowrap="nowrap">
			Link URL
		</th>
		<td>
			<xsl:if test="$edit='false'">
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="LINK"/>
					</xsl:attribute>
					<xsl:attribute name="target">_blank</xsl:attribute>
					<xsl:if test="LINK[. != '']"><xsl:value-of select="LINK"/></xsl:if>
					<xsl:if test="LINK[. = '']"><br/></xsl:if>
				</a>
			</xsl:if>
			<xsl:if test="$edit='true'">
				<input type="text" name="link" size="71">
					<xsl:attribute name="value">
						<xsl:if test="LINK[. != '']"><xsl:value-of select="LINK"/></xsl:if>
					</xsl:attribute>
				</input>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
